<?php

namespace App\Models;

use App\Enums\CategoryType;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;

class Material extends Model
{
    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class)->where('type','==',CategoryType::MATERIAL->name);
    }

    public function recipeVersionMaterials(): HasMany
    {
        return $this->hasMany(RecipeVersionMaterial::class, 'material_id');
    }
    public function recipeVersions(): HasManyThrough
    {
        return $this->hasManyThrough(
            RecipeVersion::class,
            RecipeVersionMaterial::class,
            'material_id',        // FK روی جدول میانی
            'id',                 // FK روی جدول مقصد (RecipeVersion)
            'id',                 // PK این مدل (Material)
            'recipe_version_id'   // FK داخل جدول میانی که به RecipeVersion اشاره می‌کند
        );
    }
}
