<?php

namespace App\Nova;

use App\Enums\CategoryType;
use App\Models\Category;
use Illuminate\Http\Request;
use Laravel\Nova\Actions\Action;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\FormData;
use Laravel\Nova\Fields\HasMany;
use Laravel\Nova\Fields\Hidden;
use Laravel\Nova\Fields\ID;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Fields\Stack;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Http\Requests\NovaRequest;

class CategoryResource extends Resource
{

    public static  $TYPE = null;


    public static $displayInNavigation = false;


    public static function indexQuery(NovaRequest $request, $query): \Illuminate\Contracts\Database\Eloquent\Builder
    {
//        return $query->toFlatTree();
//        return $query->withDepth();
        return $query->when(filled(self::$TYPE), function ($query){
            return $query->where('type',self::$TYPE);
        })->withDepth()->orderBy(Category::make()->getLftName(),'asc');
    }
    /**
     * The model the resource corresponds to.
     *
     * @var string
     */
    public static $model = Category::class;

    /**
     * The single value that should be used to represent the resource when being displayed.
     *
     * @var string
     */
    public static $title = 'name';

    /**
     * The columns that should be searched.
     *
     * @var array
     */
    public static $search = [
        'id', 'description'
    ];

    public static $group = "Category";

    /**
     * Get the fields displayed by the resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function fields(Request $request): array
    {
        return [
            Text::make('LFT', '_lft')->sortable('_lft')->onlyOnIndex(),

//            Stack::make('_lft', [
//                Text::make('LFT', '_lft')->sortable('_lft')->onlyOnIndex(),
//                Text::make('Order', function () {
//                    return str_repeat('— ', $this->depth) . $this->name;
//                })->onlyOnIndex(),
//            ]),



            ID::make(),

            Text::make('Name')
//                ->sortable()
                ->rules('required'),

            Text::make('Description')
//                ->sortable()
                ->hideFromIndex()

                ->rules('nullable'),

            Hidden::make('Type')
                ->default(self::$TYPE)
                ->rules('required')
                ->onlyOnForms()
            ->when(filled(self::$TYPE) || filled($this->resource->type),function ($field){
                $field->show();
            },function ($field){
                $field->hide();
            }),
            Select::make('Type')
                ->options(CategoryType::class)
                ->default(self::$TYPE)
                ->hideWhenUpdating(true)
//                ->hide()
                ->when(is_null(self::$TYPE),function ($field){
                    $field->show();
                },function ($field){
                    $field->hide();
                })
                ->hideFromIndex()
                ->rules('required'),


//            Select::make('parent_id','parent_id')
//                ->options(function () {
//                    $c = [];
//                    $cat = Category::where('id', '!=', $this->resource->id)->get();
//                    foreach ($cat as $category){
//                        $c[$category->id] = $category->name;
//                    }
//                    return $c;
//                })
//                ->sortable()->onlyOnForms()
//                ->rules('nullable'),


            BelongsTo::make('Parent', 'parent', self::class)
                ->nullable()
                ->dependsOn('type', function (BelongsTo $field, NovaRequest $request, FormData $formData) {
                    if ($formData->filled('type')) {
                        $field->relatableQueryUsing(function (NovaRequest $request, $query) use ($formData) {
                            return $query->where('type',strtoupper($formData->get('type')));

                        });

                    }
                })
                ->searchable()
                ->relatableQueryUsing(function (NovaRequest $request, $query) {


                    if ($request->resourceId) {
                        $category = \App\Models\Category::find($request->resourceId);

                        if ($category) {
                            // حذف خودش
                            $query->where('id', '!=', $category->id);

                            // حذف تمام فرزندان
                            $query->whereNotDescendantOf($category);
                        }
                    }

                    return $query;
                }),

            HasMany::make('ancestors','ancestors',CategoryResource::class)->compact(),
            HasMany::make('descendants','descendants',self::class),
//                ->with(fn ($request, $relatedModel) => [
//                    Text::make('pivot.extra'),
//                ])
//            BelongsTo::make('Parent','parent',CategoryResource::class)->exceptOnForms()
        ];
    }

    /**
     * Get the cards available for the request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function cards(Request $request): array
    {
        return [];
    }

    /**
     * Get the filters available for the resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function filters(Request $request): array
    {
        return [
//            \App\Nova\Filters\CategoryType::make()
        ];
    }

    /**
     * Get the lenses available for the resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function lenses(Request $request): array
    {
        return [];
    }

    /**
     * Get the actions available for the resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function actions(Request $request): array
    {
        return [];
    }
    public function authorizedToRunAction(NovaRequest $request, Action $action)
    {
        return false;

    }
    public function authorizeToDelete(Request $request)
    {
        return false;
    }

    public function authorizedToAdd(NovaRequest $request, $model)
    {
        return false;
    }
}
