<?php

namespace App\Nova;

use App\Enums\CategoryType;
use App\Models\Material;
use App\Models\RecipeVersion;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\HasMany;
use Laravel\Nova\Fields\ID;
use Laravel\Nova\Fields\Image;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Http\Requests\NovaRequest;

class MaterialResource extends Resource
{
    public static $model = Material::class;

    public static $title = 'name';

    public static $search = [
        'id', 'name', 'type', 'barcode'
    ];

    public static $group = "Material";

    public function fields(Request $request): array
    {
        return [
            ID::make()->sortable(),

            Text::make('Name')
                ->sortable()
                ->rules('required'),

            Text::make('Description')
                ->hideFromIndex()
                ->rules('nullable'),

            Number::make('Type')
                ->sortable()
                ->rules('required'),

            Text::make('Barcode')
                ->sortable()
                ->rules('required'),

            Text::make('Code')
                ->sortable()
                ->rules('nullable'),

            Number::make('Unit Weight')
                ->sortable()
                ->rules('nullable'),

            Image::make('Image')
                ->disk('public')
                ->sortable()
                ->rules('nullable'),

            BelongsTo::make('Category', 'category', CategoryResource::class)
                ->relatableQueryUsing(function (NovaRequest $request, Builder $query) {
                    $query->where('type', CategoryType::MATERIAL->name);
                })->nullable(),

            HasMany::make('Recipe Version Materials','recipeVersionMaterials',RecipeVersionMaterialResource::class),
            HasMany::make('Recipe Version','recipeVersions',RecipeVersionResource::class),
        ];
    }

    public function cards(Request $request): array
    {
        return [];
    }

    public function filters(Request $request): array
    {
        return [];
    }

    public function lenses(Request $request): array
    {
        return [];
    }

    public function actions(Request $request): array
    {
        return [];
    }
}
