<?php

namespace App\Nova;

use App\Nova\Filters\PermissionExtraValue;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Laravel\Nova\Fields\BelongsToMany;
use Laravel\Nova\Fields\ID;
use Laravel\Nova\Fields\MorphToMany;
use Laravel\Nova\Fields\Stack;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Http\Requests\NovaRequest;
use Sereny\NovaPermissions\Nova\Role;

class PermissionResource extends \Sereny\NovaPermissions\Nova\Permission
{


    public static $model = \App\Models\Permission::class;
    public array $filters = [];
    public function addFilter($filter)
    {
        $this->filters[] = $filter;
    }

    public static function indexQuery(NovaRequest $request, Builder $query)
    {
        return $query->orderByDesc('created_at');
    }

    public function fields(Request $request)
    {
        $guardOptions = $this->guardOptions($request);
        $userResource = $this->userResource();

        return [
            ID::make(__('ID'), 'id')
                ->rules('required')
                ->canSee(function ($request) {
                    return $this->fieldAvailable('id');
                }),

            Text::make(__('Name'), 'name')
                ->rules(['required', 'string', 'max:255'])
                ->creationRules('unique:' . config('permission.table_names.permissions'))
                ->updateRules('unique:' . config('permission.table_names.permissions') . ',name,{{resourceId}}')
                ->onlyOnForms(),

            Stack::make('Details', [
                Text::make(__('Name'), 'name')
                    ->exceptOnForms(),

                Text::make('SUB')->resolveUsing(function () {
                    $name = explode('.',optional($this->resource)->name);
                    return __($name[1]) . __($name[0]);
                }),
            ]),

            Text::make(__('Group'), 'group')
                ->rules(['required', 'string', 'max:255']),


            BelongsToMany::make(__('Roles'), 'roles', Role::class)
//                ->fields(fn ($request, $relatedModel) => [
//                    Text::make('pivot.extra'),
//                ])
                ->canSee(function ($request) {
                    return $request->user()->hasPermissionTo('viewRole');
                }),

            MorphToMany::make(__('Users'), 'users', UserResource::class)
                ->fields(fn ($request, $relatedModel) => [
                    Text::make('extra'),
                ])
                ->searchable()
                ->canSee(function ($request) {
                    return $request->user()->hasPermissionTo('viewPermission');
                }),];
    }


    public function filters(NovaRequest $request)
    {
        return array_merge($this->filters, [
//            PermissionExtraValue::make()
        ]);
    }



    public function authorizedToView(Request $request)
    {
        return false;
    }

    public function authorizedToReplicate(Request $request)
    {
        return false;
    }
    public function authorizedToDelete(Request $request)
    {
        return false;
    }
}

