<?php

namespace App\Nova;

use App\Enums\CategoryType;
use App\Models\Recipe;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\HasMany;
use Laravel\Nova\Fields\ID;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Http\Requests\NovaRequest;

class RecipeResource extends Resource
{
    public static $model = Recipe::class;

    public static $title = 'name';

    public static $search = [
        'id', 'name'
    ];
    public static $group = "Recipe";

    public function fields(Request $request): array
    {
        return [
            ID::make()->sortable(),

            Text::make('Name')
                ->sortable()
                ->rules('required'),

            Number::make('Code')
                ->sortable()
                ->rules('required', 'integer'),

            Number::make('Empty Weight')
                ->sortable()
                ->rules('nullable', 'decimal:2'),

            Number::make('Discharge Time')
                ->sortable()
                ->rules('nullable', 'integer'),

            BelongsTo::make('Category', 'category', CategoryResource::class)
                ->relatableQueryUsing(function (NovaRequest $request, Builder $query) {
                    $query->where('type', CategoryType::RECIPE->name);
                })->nullable(),


            HasMany::make('Recipe Versions','recipeVersions',RecipeVersionResource::class),
        ];
    }

    public function cards(Request $request): array
    {
        return [];
    }

    public function filters(Request $request): array
    {
        return [];
    }

    public function lenses(Request $request): array
    {
        return [];
    }

    public function actions(Request $request): array
    {
        return [];
    }
}
