<?php

namespace App\Nova;

use App\Enums\RecipeType;
use App\Models\RecipeVersion;
use Illuminate\Http\Request;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\Boolean;
use Laravel\Nova\Fields\HasMany;
use Laravel\Nova\Fields\ID;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Fields\Text;

class RecipeVersionResource extends Resource
{
    public static $model = RecipeVersion::class;

    public static $title = 'name';

    public static $search = [
        'id', 'name', 'description', 'type'
    ];
    public static $group = "Recipe";

    public static $with = ['recipe'];

    public function fields(Request $request): array
    {
        return [
            ID::make()->sortable(),

            Text::make('Name')
                ->sortable()
                ->rules('required'),

            Number::make('Code')
                ->sortable()
                ->max(9999)
                ->min(0001)
                ->maxlength(4)
                ->rules('required', 'integer'),

            Boolean::make('Is Enabled','is_enabled')
                ->default(false)
                ->rules('required'),

            Text::make('Description')
                ->hideFromIndex()
                ->rules('nullable'),

            Select::make('Type')
                ->options(RecipeType::class)
                ->sortable()
                ->rules('required'),

            Text::make('Material Count', function () {
                return $this->recipeVersionMaterials()->count();
            })->exceptOnForms(),

            BelongsTo::make('Recipe', 'recipe', RecipeResource::class)->peekable()
                ->searchable(),
            HasMany::make('Recipe Version Materials', 'recipeVersionMaterials', RecipeVersionMaterialResource::class),
        ];
    }

    public function cards(Request $request): array
    {
        return [];
    }

    public function filters(Request $request): array
    {
        return [];
    }

    public function lenses(Request $request): array
    {
        return [];
    }

    public function actions(Request $request): array
    {
        return [];
    }
}
