<?php

namespace App\Nova;


use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Laravel\Nova\Fields\BelongsToMany;
use Laravel\Nova\Fields\FormData;
use Laravel\Nova\Fields\Hidden;
use Laravel\Nova\Fields\ID;
use Laravel\Nova\Fields\MorphToMany;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Fields\URL;
use Laravel\Nova\Http\Requests\NovaRequest;
use Laravel\Nova\Nova;
use Laravel\Nova\Panel;
use Laravel\Nova\Tabs\Tab;
use Sereny\NovaPermissions\Fields\Checkboxes;

class RoleResource extends \Sereny\NovaPermissions\Nova\Role
{

    public static $model = \App\Models\Role::class;
    public static $hiddenFields = ['guard_name','id'];
    public function fields(Request $request)
    {
        $guardOptions = $this->guardOptions($request);
        return [

                ID::make(__('ID'), 'id')
                    ->rules('required')
                    ->canSee(function ($request) {
                        return $this->fieldAvailable('id');
                    }),

                Text::make(__('Name'), 'name')
                    ->rules(['required', 'string', 'max:255'])
                    ->hideFromDetail()
                    ->creationRules('unique:' . config('permission.table_names.roles'))
                    ->updateRules('unique:' . config('permission.table_names.roles') . ',name,{{resourceId}}'),


                Checkboxes::make(__('Permissions'), 'permissions')
                    ->options($this->loadPermissions()->map(function ($permission, $key) {
                        return [
                            'group'  => __(ucfirst($permission->group)),
                            'option' => $permission->name,
                            'label'  => __($permission->name),
                        ];
                    })
                        ->groupBy('group')
                        ->toArray()),

                Text::make(__('Users'), function () {
                    /**
                     * We eager load count for the users relationship in the index query.
                     * @see self::indexQuery()
                     */
                    return isset($this->users_count) ? $this->users_count : $this->users()->count();
                })->exceptOnForms(),

                Tab::group(__('Relations'), [
                    MorphToMany::make(__('Users'), 'users', UserResource::class)
                        ->searchable()
                        ->canSee(function ($request) {
                            return $this->fieldAvailable('users');
                        }),

                    BelongsToMany::make(__('Permissions'), 'permissions', PermissionResource::class)
                        ->relatableQueryUsing(function (NovaRequest $request, Builder $query) {
                            $ids = Role::findById($request->resourceId)
                                ->loadMissing('permissions')->permissions->pluck('id');
                            return $query->whereNotIn('id',$ids);
                        })
                        ->fields(function ($request, $relatedModel) {
                            $model = data_get($relatedModel,'model');
                            $url = null;
                            $label = '-';
                            if (filled($model) && class_exists('\\'.$model)) {
                                $resource = Nova::resourceForModel($model);
                                $label = $resource::singularLabel()." | ".data_get($relatedModel,'pivot.extra') ;
                                $url = route('nova.pages.detail', ['resource' => $resource::uriKey(),'resourceId' => data_get($relatedModel,'pivot.extra')]);
                            }
                            return [
//                                Text::make(__('Extra'), 'extra'),
                                URL::make(__('Link'), fn () => $url)
                                    ->displayUsing(fn () => $label)->exceptOnForms(),
//
                            ];
                        })
                        ->showCreateRelationButton()

                ]),






        ];
    }
//    public function authorizedToView(Request $request)
//    {
//        return false;
//    }

    public function authorizedToReplicate(Request $request)
    {
        return false;
    }

}
