<?php

namespace App\Policies;

use App\Models\Category;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Database\Eloquent\Model;

class CategoryPolicy extends BasePolicy
{
    use HandlesAuthorization;


    public $key = 'category';

    /**
     * Determine whether the user can view any categories.
     *
     * @param  User  $user
     * @return bool
     */
    public function viewAny(User $user): bool
    {
        return parent::viewAny($user);
    }

    /**
     * Determine whether the user can view the category.
     *
     * @param  User  $user
     * @param  Category  $category
     * @return bool
     */
    public function view(User $user,  $category): bool
    {
        return parent::view($user, $category);
    }

    /**
     * Determine whether the user can create categories.
     *
     * @param  User  $user
     * @return bool
     */
    public function create(User $user): bool
    {
        return parent::create($user);
    }

    /**
     * Determine whether the user can update the category.
     *
     * @param  User  $user
     * @param  Category  $category
     * @return bool
     */
    public function update(User $user,  $category): bool
    {
        return parent::update($user, $category);
    }

    /**
     * Determine whether the user can delete the category.
     *
     * @param  User  $user
     * @param  Category  $category
     * @return bool
     */
    public function delete(User $user,  $category): bool
    {
        return parent::delete($user, $category);
    }

    /**
     * Determine whether the user can restore the category.
     *
     * @param  User  $user
     * @param  Category  $category
     * @return bool
     */
    public function restore(User $user,  $category): bool
    {
        return parent::restore($user, $category);
    }

    /**
     * Determine whether the user can permanently delete the category.
     *
     * @param  User  $user
     * @param  Category  $category
     * @return bool
     */
    public function forceDelete(User $user,  $category): bool
    {
        return parent::forceDelete($user, $category);
    }
}
