<?php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
//use Sereny\NovaPermissions\Policies\BasePolicy;
//use Illuminate\Database\Eloquent\Model as User;

/**
 * @PolicyClass
 * @Group(role)
 * @Columns(id , name , guard_name , created_at , updated_at)
 * @DefaultColumns(id , name , guard_name  , created_at)
 * @HiddenColumns()
 * @Cards()
 * @Lenses()
 * @Filters()
 * @Actions()
 */
class RolePolicy extends BasePolicy
{
    use HandlesAuthorization;


    public $key = 'role';


    /**
     * @Queries(limitedQuery , isActive , hasVerifiedEmail)
     * @Cards()
     * @Lenses()
     * @Filters()
     * @Actions()
     */
    public function viewAny(User $user): bool
    {
        return parent::viewAny($user);
    }


    /**
     * @DefaultColumns()
     * @Columns()
     * @HiddenColumns()
     * @Cards()
     * @Lenses()
     * @Filters()
     * @Actions(Impersonate)
     */
    public function view(User $user, $model): bool
    {
        return parent::view($user, $model);
    }



    /**
     * @DefaultColumns()
     * @Columns()
     * @HiddenColumns()
     * @Cards()
     */
    public function create(User $user): bool
    {
        return parent::create($user);
    }


    /**
     * @DefaultColumns()
     * @Columns()
     * @HiddenColumns()
     * @Cards()
     */
    public function update(User $user, $model): bool
    {
        return parent::update($user, $model);
    }

    public function delete(User $user, $model): bool
    {
        return parent::delete($user, $model);
    }

    public function restore(User $user, $model): bool
    {
        return parent::restore($user, $model);
    }

    public function forceDelete(User $user, $model): bool
    {
        return parent::forceDelete($user, $model);
    }
}
