<?php

namespace App\Policies;
//use Sereny\NovaPermissions\Policies\BasePolicy;
//use Illuminate\Database\Eloquent\Model as User;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Database\Eloquent\Model;


/**
 * @PolicyClass
 * @Columns(id , name , email , email_verified_at , password , remember_token , created_at , updated_at , two_factor_secret , two_factor_recovery_codes , two_factor_confirmed_at)
 * @HiddenColumns(password, email_verified_at, remember_token, two_factor_secret, two_factor_recovery_codes)
 * @Cards(lastUsers , max)
 * @Lenses(activeUsers , disableUsers , verifiedEmail )
 * @Filters(userStatus , emailVerifiedStatus )
 * @Actions(exportCsv , Impersonate)
 */
class UserPolicy extends BasePolicy
{
    use HandlesAuthorization;


    public $key = 'user';

    /**
     * @Columns(id,email)
     * @Queries(limitedQuery , isActive , hasVerifiedEmail)
     * @Components(lastUsers , max)
     */
    public function viewAny(User $user): bool
    {
        return parent::viewAny($user);
    }

    /**
     * Determine whether the user can view the user.
     *
     * @param  User  $user
     * @param  User  $model
     * @return bool
     */
    public function view(User $user,  $model): bool
    {

        return parent::view($user, $model);
    }

    /**
     * Determine whether the user can create users.
     *
     * @param  User  $user
     * @return bool
     */
    public function create(User $user): bool
    {
        return parent::create($user);
    }

    /**
     * Determine whether the user can update the user.
     *
     * @param  User  $user
     * @param  User  $model
     * @return bool
     */
    public function update(User $user,  $model): bool
    {
        return parent::update($user, $model);
    }

    /**
     * Determine whether the user can delete the user.
     *
     * @param  User  $user
     * @param  User  $model
     * @return bool
     */
    public function delete(User $user,  $model): bool
    {
        return parent::delete($user, $model);
    }

    /**
     * Determine whether the user can restore the user.
     *
     * @param  User  $user
     * @param  User  $model
     * @return bool
     */
    public function restore(User $user,  $model): bool
    {
        return parent::restore($user, $model);
    }

    /**
     * Determine whether the user can permanently delete the user.
     *
     * @param  User  $user
     * @param  User  $model
     * @return bool
     */
    public function forceDelete(User $user,  $model): bool
    {
        return parent::forceDelete($user, $model);
    }




    public function canImpersonate(User $user,  $model): bool
    {
        return  $this->hasPermissionTo($user,'canImpersonate') || $this->hasPermissionTo($user,'canImpersonate',$user->id);
    }
    public function notBeingImpersonated(User|Model $user,  $model): bool
    {
        return !session()->has('nova_impersonated_by')  &&
            ($user->id == $model->id || $user->isSuperAdmin()) ;
    }

}
