<?php //79ad678ba319692f3ab962898abdde7ca39f4994eba252186af1324be4ebb520
/** @noinspection all */

namespace App\Models {

    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Laravel\Sanctum\PersonalAccessToken;
    use LaravelIdea\Helper\App\Models\_IH_Category_C;
    use LaravelIdea\Helper\App\Models\_IH_Category_QB;
    use LaravelIdea\Helper\App\Models\_IH_Material_C;
    use LaravelIdea\Helper\App\Models\_IH_Material_QB;
    use LaravelIdea\Helper\App\Models\_IH_Permission_C;
    use LaravelIdea\Helper\App\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\App\Models\_IH_RecipeVersionMaterial_C;
    use LaravelIdea\Helper\App\Models\_IH_RecipeVersionMaterial_QB;
    use LaravelIdea\Helper\App\Models\_IH_RecipeVersion_C;
    use LaravelIdea\Helper\App\Models\_IH_RecipeVersion_QB;
    use LaravelIdea\Helper\App\Models\_IH_Recipe_C;
    use LaravelIdea\Helper\App\Models\_IH_Recipe_QB;
    use LaravelIdea\Helper\App\Models\_IH_Role_C;
    use LaravelIdea\Helper\App\Models\_IH_Role_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_C;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_QB;
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $description
     * @property string $type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Material_C|Material[] $materials
     * @property-read int $materials_count
     * @method HasMany|_IH_Material_QB materials()
     * @property _IH_Recipe_C|Recipe[] $recipes
     * @property-read int $recipes_count
     * @method HasMany|_IH_Recipe_QB recipes()
     * @method static _IH_Category_QB onWriteConnection()
     * @method _IH_Category_QB newQuery()
     * @method static _IH_Category_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Category_QB query()
     * @method static _IH_Category_QB with(array|string $relations)
     * @method _IH_Category_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Category_C|Category[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\Material,category_id|id,\App\Models\Recipe,category_id
     * @mixin _IH_Category_QB
     */
    class Category extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $description
     * @property int $type
     * @property string $barcode
     * @property string|null $code
     * @property string|float|null $unit_weight
     * @property int|null $category_id
     * @property string|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @method static _IH_Material_QB onWriteConnection()
     * @method _IH_Material_QB newQuery()
     * @method static _IH_Material_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Material_QB query()
     * @method static _IH_Material_QB with(array|string $relations)
     * @method _IH_Material_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Material_C|Material[] all($columns = ['*'])
     * @ownLinks category_id,\App\Models\Category,id
     * @foreignLinks id,\App\Models\RecipeVersionMaterial,material_id
     * @mixin _IH_Material_QB
     */
    class Material extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $title
     * @property string $group
     * @property string $guard_name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @method static _IH_Permission_QB onWriteConnection()
     * @method _IH_Permission_QB newQuery()
     * @method static _IH_Permission_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Permission_QB query()
     * @method static _IH_Permission_QB with(array|string $relations)
     * @method _IH_Permission_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Permission_C|Permission[] all($columns = ['*'])
     * @foreignLinks 
     * @mixin _IH_Permission_QB
     */
    class Permission extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property int $code
     * @property string|float|null $empty_weight
     * @property int|null $discharge_time
     * @property int|null $category_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_RecipeVersion_C|RecipeVersion[] $recipeVersions
     * @property-read int $recipe_versions_count
     * @method HasMany|_IH_RecipeVersion_QB recipeVersions()
     * @method static _IH_Recipe_QB onWriteConnection()
     * @method _IH_Recipe_QB newQuery()
     * @method static _IH_Recipe_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Recipe_QB query()
     * @method static _IH_Recipe_QB with(array|string $relations)
     * @method _IH_Recipe_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Recipe_C|Recipe[] all($columns = ['*'])
     * @ownLinks category_id,\App\Models\Category,id
     * @foreignLinks id,\App\Models\RecipeVersion,recipe_id
     * @mixin _IH_Recipe_QB
     */
    class Recipe extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property int $code
     * @property bool $is_enabled
     * @property string|null $description
     * @property string $type
     * @property int $recipe_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Recipe $recipe
     * @method BelongsTo|_IH_Recipe_QB recipe()
     * @method static _IH_RecipeVersion_QB onWriteConnection()
     * @method _IH_RecipeVersion_QB newQuery()
     * @method static _IH_RecipeVersion_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_RecipeVersion_QB query()
     * @method static _IH_RecipeVersion_QB with(array|string $relations)
     * @method _IH_RecipeVersion_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RecipeVersion_C|RecipeVersion[] all($columns = ['*'])
     * @ownLinks recipe_id,\App\Models\Recipe,id
     * @foreignLinks id,\App\Models\RecipeVersionMaterial,recipe_version_id
     * @mixin _IH_RecipeVersion_QB
     */
    class RecipeVersion extends Model {}
    
    /**
     * @property int $id
     * @property int $recipe_version_id
     * @property int $material_id
     * @property string|float $qty
     * @property string|float|null $target_weight
     * @property string|float|null $zero_band
     * @property string|float|null $upper_threshold
     * @property string|float|null $lower_threshold
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Material $material
     * @method BelongsTo|_IH_Material_QB material()
     * @property RecipeVersion $recipeVersion
     * @method BelongsTo|_IH_RecipeVersion_QB recipeVersion()
     * @method static _IH_RecipeVersionMaterial_QB onWriteConnection()
     * @method _IH_RecipeVersionMaterial_QB newQuery()
     * @method static _IH_RecipeVersionMaterial_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_RecipeVersionMaterial_QB query()
     * @method static _IH_RecipeVersionMaterial_QB with(array|string $relations)
     * @method _IH_RecipeVersionMaterial_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RecipeVersionMaterial_C|RecipeVersionMaterial[] all($columns = ['*'])
     * @ownLinks recipe_version_id,\App\Models\RecipeVersion,id|material_id,\App\Models\Material,id
     * @mixin _IH_RecipeVersionMaterial_QB
     */
    class RecipeVersionMaterial extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $guard_name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @method static _IH_Role_QB onWriteConnection()
     * @method _IH_Role_QB newQuery()
     * @method static _IH_Role_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Role_QB query()
     * @method static _IH_Role_QB with(array|string $relations)
     * @method _IH_Role_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Role_C|Role[] all($columns = ['*'])
     * @foreignLinks 
     * @mixin _IH_Role_QB
     */
    class Role extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property mixed $password
     * @property bool $is_active
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $two_factor_secret
     * @property string|null $two_factor_recovery_codes
     * @property Carbon|null $two_factor_confirmed_at
     * @property _IH_Permission_C|Permission[] $fixedPermissions
     * @property-read int $fixed_permissions_count
     * @method MorphToMany|_IH_Permission_QB fixedPermissions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all($columns = ['*'])
     * @foreignLinks 
     * @mixin _IH_User_QB
     * @method static UserFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class User extends Model {}
}